VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsRegistration"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'
' Return values from the Register method.
'
'dss
'Private Const cregRegistered = 0
'Private Const cregEvaluating = 1
'Private Const cregExpired = 2
'Private Const cregError = -99

Public Enum RegisterValues
    eregRegistered = 0
    eregEvaluating = 1
    eregExpired = 2
    eregError = -99
End Enum

Public Property Get regRegistered() As Long

'    regRegistered = cregRegistered

End Property
Public Property Get regEvaluating() As Long

'    regEvaluating = cregEvaluating

End Property
Public Property Get regExpired() As Long

'    regExpired = cregExpired

End Property
Public Property Get regError() As Long

'    regError = cregError

End Property

Public Function Register(ByRef strError As String) As Long

    '
    '---------------------------------------------------------------------
    ' Check the registration status of your application.
    '
    ' Return Values:
    '   cregRegistered - Properly Registered.
    '   cregEvaluating - Not registered. Evaluation period not expired.
    '   cregExpired    - Not registered. Evaluation period expired.
    '   cregError      - Error occured.
    '
    '   strError       - Contains the error message on error.
    '---------------------------------------------------------------------
    '
    strError = ""
    Register = cregExpired
    On Error GoTo ErrorHandler

    With gobjAppSentinel
    
    '
    ' Get the registration information.
    '
    If Not .GetRegistrationInfo(strError) Then GoTo ErrorHandler
    
    '
    ' Validate the existing registration information.
    '
    If Not .CheckRegistration(strError) Then GoTo ErrorHandler
    
    '
    ' Is this the first time your application was run?
    '
    If .InitialRun Then
        '
        ' Yes. Return with the appropriate value.
        '
        Register = cregEvaluating
    Else
        '
        ' No. Is your application registered?
        '
        If .Registered Then
            '
            ' Yes.
            '
            Register = cregRegistered
        Else
            '
            ' No. It is being evaluated.
            ' Is it expired?
            '
            If .Expired Then
                Register = cregExpired
                '
                ' Yes. Show the Registration screen to give
                ' the user the opportunity to register.
                '
                With frmRegister
                    .WebSite = cYourURL
                    .EMailAddress = cYourEmail
                    .AppTitle = cThisAppsTitle
                    .Show vbModal
                End With
                '
                ' Re-read the Registration information
                ' in case the user just registered.
                '
                If Not .GetRegistrationInfo(strError) Then GoTo ErrorHandler
                
                '
                ' Validate the just entered registration information.
                '
                If Not .CheckRegistration(strError) Then GoTo ErrorHandler
                
                '
                ' Did the user successfully register?
                '
                If .Registered Then
                    '
                    ' Yes.
                    '
                    Register = cregRegistered
                Else
                    '
                    ' No and we are expired.
                    '
                    Register = cregExpired
                End If
            Else
                '
                ' The user still has time/runs left
                ' in the evaluation period.
                '
                Register = cregEvaluating
            End If
        End If
    End If
    
    End With
    
    GoTo NormalExit

    
ErrorHandler:
    '
    ' We're here because a method of AppSentinel returned false.
    ' Assume your application is not registered or expired.
    '
    Register = cregError
    If strError = "" Then strError = Err.Description
    
NormalExit:
End Function


